<?php

require_once MAX_PATH . '/lib/OA.php';
require_once MAX_PATH . '/lib/max/Plugin/Common.php';
require_once LIB_PATH . '/Extension/bannerTypeHtml/bannerTypeHtml.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';

if($GLOBALS['_MAX']['CONF']['database']['type']=='mysql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='pgsql')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/pgsql.php';
}
else if($GLOBALS['_MAX']['CONF']['database']['type']=='mysqli')
{
require_once MAX_PATH . '/lib/OA/Dal/Delivery/mysqli.php';
}

class Plugins_BannerTypeHTML_Videoads_backgroundvideoads extends Plugins_BannerTypeHTML
{
    /**
     * Return type of plugin
     *
     * @return string A string describing the type of plugin.
     */
     
    function getStorageType()
    {
        return 'html';
    }

    /**
     * Return the media (content) type
     *
     */
    function getContentType()
    {
        return 'html';
    }
     
    function getOptionDescription()
    {
        return $this->translate("Background Video Ads");
    }

    function validateForm(&$form)
    {
        return true;
    }

    function processForm($insert, $bannerid, $aFields , $aVariables)
    {

        $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
        $rm_video = '';


        if($_FILES['rm_video']['name'] != '' && $_POST['vid_upload_type'] == "Internal")
        { 
            $target_dir =  $GLOBALS['_MAX']['CONF']['webpath']['images'];
            $target_file = $target_dir ."/". basename($_FILES["rm_video"]["name"]);

            $image = $_FILES['rm_video']['tmp_name'];
            $rm_video = $_FILES['rm_video']['name'];
            $location = "../images/";
    
            if (!file_exists($location.$rm_video)) 
            {
                move_uploaded_file($image,$location.$rm_video);
            }

            $video_url = "";
        }

        else if($_POST['vid_upload_type'] == "External" && $_POST['video_url'] != '')
        {
            $rm_video = '';
            $video_url = $_POST['video_url'];
        }

        else if($_FILES['rm_video']['name'] == '' && $_POST['vid_upload_type'] == "Internal" && $_POST['adupload_type'] != '')
        {
            $rm_video = $_POST['pre_vid'];
        }

        $inlinefields = array(
                        'vid_upload_type'   => $_POST['vid_upload_type'],
                        'video_url'         => $video_url,
                        'destination_url'   => $_POST['destination_url'],
                        'weight'            => $_POST['weight'],
                        'keyword'           => $_POST['keyword'],
                        'comments'          => $_POST['comments'],
                        'description'       => $_POST['description'],
                        'tp_tag'            => $_POST['tp_tag'],
                        'extension_type'    => $_POST['extension_type'],
                        // 'external_wrapper'  => $_POST['external_wrapper'],
                        'skip'              => $_POST['skip'],
                        'rm_video'          => $rm_video
                    );


        OA_Dal_Delivery_query("update {$table_prefix}banners set parameters = '".
        serialize($inlinefields)."',url='".$_POST['destination_url']."' where bannerid = ".$bannerid);
       
        return true;
    }
     
    function preprocessForm($insert, $bannerid, &$aFields, &$aVariables)
    {
        return true;
    }
    
    function buildForm(&$form, &$row)
    {
        //FETCH VALUE 
        $table_prefix = $GLOBALS['_MAX']['CONF']['table']['prefix'];
        $array = OA_Dal_Delivery_query("select parameters from {$table_prefix}banners where bannerid ='".$row['bannerid']."' ");
        $values1 = OA_Dal_Delivery_fetchAssoc($array);

        $values = unserialize($values1['parameters']);

        $form->addElement('hidden','adupload_type',"","");
        $form->addElement('hidden','pre_vid',"","");

        //~INTERNAL / EXTERNAL TYPE 
       
       
        //~INTERNAL / EXTERNAL VIDEO TYPE
        $VUtype[] = $form->createElement('radio', 'vid_upload_type',"", "Video Upload", "Internal", array("id" => "vid_internal","values" => "Internal"));
        $VUtype[] = $form->createElement('radio', 'vid_upload_type',"", "Video URL", "External", array("id"=>"vid_external","values"=> "External"));

        $form->addGroup($VUtype, 'vid_upload_type', 'Select Video Type', "&nbsp;", false);

        addUploadGroup($form, $row,
            array(
                'uploadName' => 'rm_video',
                'radioName' => 'rm_rvideo',
                'imageName'  => $front_image,
                'fileName'  => $values['rm_video'],
                'fileSize'  => $front_size,
                'newLabel'  => "Select the <b>Video </b> you want to use for this banner",
                'updateLabel'  => "Do you wish to keep your existing <b>Video</b>, or do you want to upload another?",
                'handleSWF' => true
              )
        );
        $form->addElement('text', 'video_url', 'Video URL');
        $extension_type = array("MP4" => "MP4","WEBM" => "WEBM","HLS" => "HLS");
        $form->addElement('select', 'extension_type','Extension Type',$extension_type); 
        $form->addElement('text', 'skip', 'Skip (In Secs.)', array("placeholder"=> "00:00:00"));
        $form->addElement('text', 'destination_url',"Destination URL");

        $front_image = _getContentTypeIconImageName($row['contenttype']);
        $front_size = _getBannerSizeText($type, $row['filename']);   

        // $form->addElement('textarea', 'external_wrapper', 'Third Party Wrapper');
        
        $form->addElement('header', 'header_b_display', 'Banner display');
        $sizeG['width'] = $form->createElement('text', 'width', $GLOBALS['strWidth'].":");
        $sizeG['width']->setAttribute('onChange', 'oa_sizeChangeUpdateMessage("warning_change_banner_size");');
        $sizeG['width']->setSize(5);

        $sizeG['height'] = $form->createElement('text', 'height', $GLOBALS['strHeight'].":");
        $sizeG['height']->setAttribute('onChange', 'oa_sizeChangeUpdateMessage("warning_change_banner_size");');
        $sizeG['height']->setSize(5);
        $form->addGroup($sizeG, 'size', $GLOBALS['strSize'], "&nbsp;", false);

        $form->addElement('header', 'header_b_links', "Banner link");
        $form->addElement('text', 'tp_tag', 'Third Party Tags (optional)',$tp_tag);



        //~DEFAULT VALUES
        $form->setDefaults(array(vid_upload_type => $values['vid_upload_type']));
        $form->setDefaults(array(video_url => $values['video_url'])); 
        $form->setDefaults(array(destination_url => $values['destination_url'])); 
        // $form->setDefaults(array(external_wrapper => $values['external_wrapper'])); 

        $form->setDefaults(array(tp_tag => $values['tp_tag'])); 
        $form->setDefaults(array(skip => $values['skip'])); 
        $form->setDefaults(array(pre_vid => $values['rm_video']));
        
        //~UNIQUE BANNER FOR BANNER LINK
        $form->addElement('hidden', 'ext_bannertype', $this->getComponentIdentifier());

        //~JS
        $form->addElement('html', 'jsForVIDEO', '<script>
            $(document).ready(function()
            {
                $("input[type=file]").attr("id","rm_video");
                var vidtype = "'.$values['vid_upload_type'].'";
                vid_upload(vidtype);
                //$("#video_url").parent().parent().hide();
                //$("#rm_video").parent().parent().hide();
             
                //~FOR VIDEO UPLOAD TYPE SELECTION
                $("input[name = vid_upload_type]").click(function(){
                    vid_upload($(this).val());
                });

                function vid_upload(up_type)
                {
                    if(up_type == "External"){
                        $("#video_url").parent().parent().show();
                        $("#rm_video").parent().parent().hide();
                    }
                    else{
                        $("#video_url").parent().parent().hide();
                        $("#rm_video").parent().parent().show();
                    }
                }
            });

            var validation_status = "pending";

            //~VALIDATION

            $("#rm_video").change(function() 
            {
                var file = $(this).val();
                var exts = ["mp4", "webm", "hls"];

                // first check if file field has any value

                if (file) 
                {
                    // split file name at dot
                    var get_ext = file.split(".");

                    // reverse name to check extension
                    get_ext = get_ext.reverse();

                    // check file type is valid as given in "exts" array
                    if ($.inArray(get_ext[0].toLowerCase(), exts) > -1) {
                        $("#submit").show();
                    } 
                    else {
                        alert("Invalid file!");
                        $("#submit").hide();
                    }
                }
            });
        </script>');
        
        $translation = new OX_Translation();

        $form->addRule('vid_upload_type', 'Video Upload Type is Required', 'required');     

        $widthRequiredRule = array($translation->translate($GLOBALS['strXRequiredField'], array($GLOBALS['strWidth'])), 'required');
        $widthPositiveRule = array($translation->translate($GLOBALS['strXGreaterThanZeroField'], array($GLOBALS['strWidth'])), 'min', 1);
        $heightRequiredRule = array($translation->translate($GLOBALS['strXRequiredField'], array($GLOBALS['strHeight'])), 'required');
        $heightPositiveRule = array($translation->translate($GLOBALS['strXGreaterThanZeroField'], array($GLOBALS['strHeight'])), 'min', 1);
        $numericRule = array($GLOBALS['strNumericField'] , 'numeric');

        $form->addGroupRule('size', array(
            'width' => array($widthRequiredRule, $numericRule, $widthPositiveRule),
            'height' => array($heightRequiredRule, $numericRule, $heightPositiveRule)));     

    }


    
}
